/*
 * Decompiled with CFR 0.152.
 */
package org.gldhn.mcstart;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import org.gldhn.common;
import org.gldhn.mcsleep.McServerConfig;
import org.gldhn.mcstart.DisguiseServerHandler;

public class DisguiseServer {
    private static final Logger logger = Logger.getLogger(DisguiseServer.class.getName());
    private InetAddress fs_ip = InetAddress.getByName("0.0.0.0");
    private int fs_port = McServerConfig.port;
    private boolean close_request = false;
    private String result = "";
    private ServerSocket serverSocket;

    public void startServer(int maxRetries, int retryDelay) throws IOException {
        int retryCount = 0;
        while (retryCount < maxRetries && !this.close_request) {
            try {
                this.serverSocket = new ServerSocket();
                this.serverSocket.setReuseAddress(true);
                this.serverSocket.bind(new InetSocketAddress(this.fs_ip, this.fs_port), 5);
                common.Logger("\u670d\u52a1\u5668\u6b63\u5728\u76d1\u542c " + this.fs_ip.getHostAddress() + ":" + this.fs_port, 3);
                break;
            }
            catch (IOException e) {
                common.Logger("\u670d\u52a1\u5668\u542f\u52a8\u5931\u8d25: " + e.getMessage() + "\uff0c\u91cd\u8bd5\u4e2d...", 1);
                if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                    this.serverSocket.close();
                }
                ++retryCount;
                try {
                    Thread.sleep(retryDelay * 1000);
                    retryDelay *= 2;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Thread was interrupted during sleep", ie);
                }
            }
        }
        if (!this.close_request) {
            this.listenForConnections();
        }
    }

    private void listenForConnections() {
        while (!"connection_request".equals(this.result) && !this.close_request) {
            try {
                Socket clientSocket = this.serverSocket.accept();
                common.Logger("\u6536\u5230\u6765\u81ea" + clientSocket.getInetAddress().getHostAddress() + ":" + clientSocket.getPort() + "\u7684\u8fde\u63a5", 0);
                InputStream input = clientSocket.getInputStream();
                byte[] buffer = new byte[1024];
                int bytesRead = input.read(buffer, 0, buffer.length);
                byte[] recvData = new byte[]{};
                if (bytesRead > 0) {
                    recvData = new byte[bytesRead];
                    System.arraycopy(buffer, 0, recvData, 0, bytesRead);
                } else {
                    common.Logger("No more data or connection closed.", 1);
                }
                DisguiseServerHandler.ResultWithIndex resultWithIndex = DisguiseServerHandler.readVarInt(recvData, 0);
                DisguiseServerHandler.ResultWithIndex resultWithIndex2 = DisguiseServerHandler.readVarInt(recvData, resultWithIndex.newIndex);
                int packetID = resultWithIndex2.result;
                common.Logger("\u6536\u5230\u6765\u81ea" + clientSocket.getInetAddress().getHostAddress() + ":" + clientSocket.getPort() + "\u7684\u6570\u636e\u5305\uff0cpacketID: " + resultWithIndex.result + ", length: " + resultWithIndex2.result, 0);
                if (packetID == 0) {
                    this.result = DisguiseServerHandler.handlePing(clientSocket, recvData, resultWithIndex2.newIndex);
                    if (!this.result.equals("connection_request")) continue;
                    this.close_request = true;
                    this.serverSocket.close();
                    continue;
                }
                if (packetID != 1) continue;
                this.serverSocket.close();
                break;
            }
            catch (SocketTimeoutException ste) {
                common.Logger("\u8fde\u63a5\u8d85\u65f6", 1);
            }
            catch (IOException e) {
                common.Logger("\u53d1\u751f\u9519\u8bef: " + e.getMessage(), 1);
            }
            catch (Exception e) {
                common.Logger("\u53d1\u751f\u672a\u77e5\u9519\u8bef: " + e.getMessage() + e.getLocalizedMessage(), 1);
            }
        }
    }

    private void closeServerSocket() {
        if (this.serverSocket != null && !this.serverSocket.isClosed()) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                logger.severe("\u5173\u95ed\u670d\u52a1\u5668\u5957\u63a5\u5b57\u65f6\u51fa\u9519: " + e.getMessage());
            }
        }
    }
}

