/*
 * Decompiled with CFR 0.152.
 */
package org.gldhn.mcstart;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.gldhn.common;

public class DisguiseServerHandler {
    private static final String fs_motd = null;
    private static final List<String> fs_samples = null;
    private static final String fs_kick_message = null;

    public static String handlePing(Socket clientSocket, byte[] recvData, int startIndex) throws IOException, VarIntException {
        int i = startIndex;
        ResultWithIndex versionResult = DisguiseServerHandler.readVarInt(recvData, i);
        int version = versionResult.result;
        i = versionResult.newIndex;
        String[] ipResult = DisguiseServerHandler.readUTF(recvData, i);
        String ip = ipResult[0].replace('\u0000', ' ').replace("\r", "\\r").replace("\t", "\\t").replace("\n", "\\n");
        i = Integer.parseInt(ipResult[1]);
        boolean isUsingFML = ip.endsWith("FML");
        if (isUsingFML) {
            ip = ip.substring(0, ip.length() - 3);
        }
        ResultWithIndex portResult = DisguiseServerHandler.readUShort(recvData, i);
        int port = portResult.result;
        i = portResult.newIndex;
        ResultWithIndex stateResult = DisguiseServerHandler.readVarInt(recvData, i);
        int state = stateResult.result;
        i = stateResult.newIndex;
        if (state == 1) {
            common.Logger("\u4f2a\u88c5\u670d\u52a1\u5668\u6536\u5230\u4e86\u4e00\u6b21ping: " + Arrays.toString(recvData), 0);
            DisguiseServerHandler.writeResponse(clientSocket, "");
            return "ping_received";
        }
        if (state == 2) {
            common.Logger("\u4f2a\u88c5\u670d\u52a1\u5668\u6536\u5230\u4e86\u4e00\u6b21\u8fde\u63a5\u8bf7\u6c42: " + Arrays.toString(recvData), 0);
            DisguiseServerHandler.writeResponse(clientSocket, "");
            common.Logger("\u542f\u52a8\u670d\u52a1\u5668", 0);
            return "connection_request";
        }
        return "";
    }

    public static String[] readUTF(byte[] bytes, int i) throws VarIntException {
        ResultWithIndex result = DisguiseServerHandler.readVarInt(bytes, i);
        int length = result.result;
        i = result.newIndex;
        String ip = new String(bytes, i, length, StandardCharsets.UTF_8);
        return new String[]{ip, String.valueOf(i += length)};
    }

    private static ResultWithIndex readUShort(byte[] byteArray, int startIndex) throws IOException {
        if (startIndex + 2 > byteArray.length) {
            throw new IOException("\u8bfb\u53d6\u65e0\u7b26\u53f7\u77ed\u6574\u578b\u65f6\u8d85\u51fa\u8303\u56f4");
        }
        int result = (byteArray[startIndex] & 0xFF) << 8 | byteArray[startIndex + 1] & 0xFF;
        return new ResultWithIndex(result, startIndex + 2);
    }

    private static void writeResponse(Socket socket, String response) throws IOException {
        try (OutputStream out = socket.getOutputStream();){
            byte[] responseData = response.getBytes(StandardCharsets.UTF_8);
            DisguiseServerHandler.writeVarInt(out, responseData.length);
            out.write(responseData);
            out.flush();
        }
    }

    private static void writeVarInt(OutputStream out, int value) throws IOException {
        while ((long)(value & 0xFFFFFF80) != 0L) {
            out.write(value & 0x7F | 0x80);
            value >>>= 7;
        }
        out.write(value & 0x7F);
    }

    public static ResultWithIndex readVarInt(byte[] byteArray, int startIndex) throws VarIntException {
        byte byteIn;
        int result = 0;
        int currentIndex = startIndex;
        int byteCount = 0;
        do {
            if (currentIndex >= byteArray.length) {
                throw new VarIntException("Index out of range");
            }
            byteIn = byteArray[currentIndex];
            ++currentIndex;
            result |= (byteIn & 0x7F) << byteCount * 7;
            if (++byteCount <= 5) continue;
            throw new VarIntException("VarInt is too long!");
        } while ((byteIn & 0x80) != 0);
        return new ResultWithIndex(result, currentIndex);
    }

    public static class ResultWithIndex {
        public final int result;
        public final int newIndex;

        public ResultWithIndex(int result, int newIndex) {
            this.result = result;
            this.newIndex = newIndex;
        }
    }

    public static class VarIntException
    extends Exception {
        public VarIntException(String message) {
            super(message);
        }
    }
}

